﻿using System;
using System.Security.Principal;
using System.Web;
using System.Web.UI;
using Microsoft.SharePoint;

namespace GetIdentity.VisualWebPart1
{
   public partial class VisualWebPart1UserControl : UserControl
   {
      protected void Page_Load(object sender, EventArgs e)
      {
         // Windows-Identität des aktuell angemeldeten Benutzers
         WindowsIdentity currentWindowsIdentity = WindowsIdentity.GetCurrent();
         string userLoginName = currentWindowsIdentity.Name;

         // Windows-Identität: CONTOSO\UserA
         lblWindowsIdentity.Text = userLoginName;

         // Windows Principal mit Informationen zu den Gruppenzugehörigkeiten
         WindowsPrincipal currentPrincipal =
            new WindowsPrincipal(currentWindowsIdentity);

         // Prüfe, ob der Benutzer in der Windows-Gruppe der
         // Administratoren Mitglied ist
         if (currentPrincipal.IsInRole("Administrators"))
         {
            // Aktionen, die nur für Administratoren erlaubt sind
            lblIsAdmin.Text = "Ja";
         }

         // Bei Verwendung der Formular-basierten Authentifizierung kann die
         // Benutzeridentität aus dem HttpContext ausgelesen werden
         IPrincipal currentHttpUser = HttpContext.Current.User;
         string httpUserLoginName = currentHttpUser.Identity.Name;

         // HTTP-Identität: CONTOSO\UserA
         lblHttpIdentity.Text = httpUserLoginName;

         // SharePoint-Benutzeridentität mit zusätzlichen Informationen
         SPUser currentUser = SPContext.Current.Web.CurrentUser;
         string loginName = currentUser.LoginName;
         string displayName = currentUser.Name;
         string mailAddress = currentUser.Email;
         bool isSiteAdmin = currentUser.IsSiteAdmin;

         // SharePoint-Identität: CONTOSO\UserA
         lblSPIdentity.Text = String.Format("{0} ({1})", displayName, loginName);
      }
   }
}